float4 AmbientColor : register(c1);
sampler2D BaseMap : register(s0);
sampler2D NormalMap : register(s1);
float4 PSLightColor[4] : register(c2);
float4 Toggles : register(c7);

float4 TESR_ShadowData : register(c8);
sampler2D TESR_ShadowMapBufferNear : register(s2) = sampler_state { ADDRESSU = CLAMP; ADDRESSV = CLAMP; MAGFILTER = LINEAR; MINFILTER = LINEAR; MIPFILTER = LINEAR; };
sampler2D TESR_ShadowMapBufferFar : register(s3) = sampler_state { ADDRESSU = CLAMP; ADDRESSV = CLAMP; MAGFILTER = LINEAR; MINFILTER = LINEAR; MIPFILTER = LINEAR; };


//
//
// Registers:
//
//   Name         Reg   Size
//   ------------ ----- ----
//   AmbientColor const_1       1
//   PSLightColor[0] const_2        1
//   Toggles      const_7       1
//   BaseMap      texture_0       1
//   NormalMap    texture_1       1
//


// Structures:

struct VS_OUTPUT {
    float2 BaseUV : TEXCOORD0;
    float3 texcoord_1 : TEXCOORD1_centroid;
    float3 texcoord_3 : TEXCOORD3_centroid; 
   
    float3 texcoord_6 : TEXCOORD6_centroid;
    float4 texcoord_7 : TEXCOORD7;     
     float4 texcoord_8 : TEXCOORD8;
    float3 color_0 : COLOR0;
    float4 color_1 : COLOR1;
};

struct PS_OUTPUT {
    float4 color_0 : COLOR0;
};

#include "..\Includes\Shadow.hlsl"

PS_OUTPUT main(VS_OUTPUT IN) {
    PS_OUTPUT OUT;

#define	expand(v)		(((v) - 0.5) / 0.5)
#define	compress(v)		(((v) * 0.5) + 0.5)
#define	uvtile(w)		(((w) * 0.04) - 0.02)
#define	shade(n, l)		max(dot(n, l), 0)
#define	shades(n, l)		saturate(dot(n, l))

    float3 q10;
    float1 q2;
    float3 q3;
    float1 q7;
    float4 r0;
    float4 r1;
    float2 uv0;
    float Shadow;                           
    
    Shadow = GetLightAmount(IN.texcoord_7, IN.texcoord_8);
    
    r0.xyzw = tex2D(BaseMap, IN.BaseUV.xy);
    uv0.xy = (uvtile(r0.w) * (IN.texcoord_6.xy / length(IN.texcoord_6.xyz))) + IN.BaseUV.xy;
    r1.xyzw = tex2D(NormalMap, uv0.xy);
    r0.xyzw = tex2D(BaseMap, uv0.xy);
    q7.x = r1.w * pow(abs(shades(normalize(expand(r1.xyz)), normalize(IN.texcoord_3.xyz))), Toggles.z);
    q2.x = dot(normalize(expand(r1.xyz)), IN.texcoord_1.xyz);
    q3.xyz = saturate((0.2 >= q2.x ? (q7.x * max(q2.x + 0.5, 0)) : q7.x) * PSLightColor[0].rgb);
    r1.xyz = (Toggles.x <= 0.0 ? r0.xyz : (r0.xyz * IN.color_0.rgb));
    q10.xyz = (r1.xyz * max((Shadow * saturate(q2.x) * PSLightColor[0].rgb) + AmbientColor.rgb, 0)) + q3.xyz;
    OUT.color_0.a = AmbientColor.a;
   OUT.color_0.rgb = (Toggles.y <= 0.0 ? q10.xyz : lerp(q10.xyz, IN.color_1.rgb, IN.color_1.a));
         
  // OUT.color_0.rgb = 1;
   
    return OUT;
};

// approximately 40 instruction slots used (3 texture, 37 arithmetic)
