float3 LightDirection[3] : register(c13);
row_major float4x4 ModelViewProj : register(c0);
row_major float4x4 TESR_ShadowCameraToLightTransform[2] : register(c34);
//
//
// Registers:
//
//   Name           Reg   Size
//   -------------- ----- ----
//   ModelViewProj[0]  const_0        1
//   ModelViewProj[1]  const_1        1
//   ModelViewProj[2]  const_2        1
//   ModelViewProj[3]  const_3        1
//   LightDirection[0] const_13       1
//


// Structures:

struct VS_INPUT {
    float4 position : POSITION;
    float3 tangent : TANGENT;
    float3 binormal : BINORMAL;
    float3 normal : NORMAL;
    float4 texcoord_0 : TEXCOORD0;
    float4 color_0 : COLOR0;
    float4 LTEXCOORD_1 : TEXCOORD1;
    float4 LTEXCOORD_2 : TEXCOORD2;

#define	TanSpaceProj	float3x3(IN.tangent.xyz, IN.binormal.xyz, IN.normal.xyz)
};

struct VS_OUTPUT {
    float4 position : POSITION;
    float2 texcoord_0 : TEXCOORD0;
    float2 texcoord_1 : TEXCOORD1;
    float4 texcoord_2 : TEXCOORD2;
    float3 texcoord_3 : TEXCOORD3;
    float4 texcoord_4 : TEXCOORD4;
	  float4 texcoord_5 : TEXCOORD5;     
    float4 texcoord_6 : TEXCOORD6;
	  float4 texcoord_7 : TEXCOORD7;
};

// Code:

VS_OUTPUT main(VS_INPUT IN) {
    VS_OUTPUT OUT;

#define	expand(v)		(((v) - 0.5) / 0.5)
#define	compress(v)		(((v) * 0.5) + 0.5)

    const float4 const_4 = {0.5, 1, 0, 0};
                          
    float3 q0;
	  float4 r0;
	
    q0.xyz = mul(float3x3(IN.tangent.xyz, IN.binormal.xyz, IN.normal.xyz), LightDirection[0].xyz);
	  r0.xyzw = mul(ModelViewProj, IN.position.xyzw);
  
    OUT.position.xyzw = r0.xyzw;    
    OUT.position.xyzw = mul(ModelViewProj, IN.position.xyzw);
    OUT.texcoord_0.xy = IN.texcoord_0.xy;
    OUT.texcoord_1.xy = IN.texcoord_0.xy;
    OUT.texcoord_2.xyzw = (IN.color_0.xyzx * const_4.yyyz) + const_4.zzzy;
    OUT.texcoord_3.xyz = compress(mul(TanSpaceProj, LightDirection[0].xyz));
    OUT.texcoord_4.rgba = IN.LTEXCOORD_1.xyzw;
    OUT.texcoord_5.rgba = IN.LTEXCOORD_2.xyzw;
	  OUT.texcoord_6.xyzw = mul(r0.xyzw, TESR_ShadowCameraToLightTransform[0]);
	  OUT.texcoord_7.xyzw = mul(r0.xyzw, TESR_ShadowCameraToLightTransform[1]);

    return OUT;
};

// approximately 13 instruction slots used
