//
// Generated by Microsoft (R) D3DX9 Shader Compiler 9.08.299.0000
//
//   psa shaderdump19/GRASS2003.pso /Fcshaderdump19/GRASS2003.pso.dis
//
//
// Parameters:
//
float4 AlphaTestRef : register(c3);
sampler2D AttMap : register(s1);
sampler2D DiffuseMap : register(s0);
float4 PointLightColor : register(c2);

float4 TESR_ShadowData : register(c5);

sampler2D TESR_ShadowMapBufferNear : register(s2) = sampler_state { ADDRESSU = CLAMP; ADDRESSV = CLAMP; MAGFILTER = LINEAR; MINFILTER = LINEAR; MIPFILTER = LINEAR; };
sampler2D TESR_ShadowMapBufferFar : register(s3) = sampler_state { ADDRESSU = CLAMP; ADDRESSV = CLAMP; MAGFILTER = LINEAR; MINFILTER = LINEAR; MIPFILTER = LINEAR; };

//
//
// Registers:
//
//   Name            Reg   Size
//   --------------- ----- ----
//   PointLightColor const_2       1
//   AlphaTestRef    const_3       1
//   DiffuseMap      texture_0       1
//   AttMap          texture_1       1
//


// Structures:

struct VS_OUTPUT {
    float2 DiffuseUV : TEXCOORD0;
    float3 texcoord_4 : TEXCOORD4_centroid;
    float4 texcoord_5 : TEXCOORD5_centroid;
    float4 texcoord_1 : TEXCOORD1;
    	float4 texcoord_6 : TEXCOORD6;  
   float4 texcoord_7 : TEXCOORD7;
    float4 color_0 : COLOR0;
};

struct PS_OUTPUT {
    float4 color_0 : COLOR0;
};

// Code:
             static const float BIAS = 0.001f;


float LookupFar3(float4 ShadowPos, float2 OffSet) {
	
	float Shadow = tex2D(TESR_ShadowMapBufferFar, ShadowPos.xy + float2(OffSet.x * TESR_ShadowData.w, OffSet.y * TESR_ShadowData.w)).r;
	if (Shadow < ShadowPos.z - BIAS) return TESR_ShadowData.y;
	return 1.0f;
	
}

float GetLightAmountFar3(float4 ShadowPos) {
	
	float Shadow = 0.0f;
	float x;
	float y;
	
	ShadowPos.xyz /= ShadowPos.w;
    if (ShadowPos.x < -1.0f || ShadowPos.x > 1.0f ||
        ShadowPos.y < -1.0f || ShadowPos.y > 1.0f ||
        ShadowPos.z <  0.0f || ShadowPos.z > 1.0f)
		return 1.0f;

    ShadowPos.x = ShadowPos.x *  0.5f + 0.5f;
    ShadowPos.y = ShadowPos.y * -0.5f + 0.5f;
	
			Shadow += LookupFar3(ShadowPos, float2(0, 0));
	
	
	return Shadow;
	
} 


float Lookup3(float4 ShadowPos, float2 OffSet) {
	
	float Shadow = tex2D(TESR_ShadowMapBufferNear, ShadowPos.xy + float2(OffSet.x * TESR_ShadowData.z, OffSet.y * TESR_ShadowData.z)).r;
	if (Shadow < ShadowPos.z - BIAS) return TESR_ShadowData.y;
	return 1.0f;
	
}

float GetLightAmount3(float4 ShadowPos, float4 ShadowPosFar) {
	
	if (TESR_ShadowData.x == -1.0f) return 1.0f; // Shadows are applied in post processing (ShadowsExteriors.fx.hlsl)
	
	float Shadow = 0.0f;
	float x;
	float y;
	
	ShadowPos.xyz /= ShadowPos.w;
    if (ShadowPos.x < -1.0f || ShadowPos.x > 1.0f ||
        ShadowPos.y < -1.0f || ShadowPos.y > 1.0f ||
        ShadowPos.z <  0.0f || ShadowPos.z > 1.0f)
		return GetLightAmountFar3(ShadowPosFar);
 
    ShadowPos.x = ShadowPos.x *  0.5f + 0.5f;
    ShadowPos.y = ShadowPos.y * -0.5f + 0.5f;
	
	
				Shadow += Lookup3(ShadowPos, float2(0, 0));
	
	
	

	return Shadow;
	
}

PS_OUTPUT main(VS_OUTPUT IN) {
    PS_OUTPUT OUT;

    float1 att0;
    float1 att1;
    float3 q2;
    float4 r0;  
    float shadow;
                        
    shadow = GetLightAmount3(IN.texcoord_6, IN.texcoord_7);
    r0.xyzw = tex2D(DiffuseMap, IN.DiffuseUV.xy);
     
    att1.x = tex2D(AttMap, IN.texcoord_1.zw);
    att0.x = tex2D(AttMap, IN.texcoord_1.xy);  
    
    q2.xyz = (saturate((1 - att0.x) - att1.x) * (0.4 * PointLightColor.rgb)) + (shadow * IN.texcoord_5.xyz + IN.texcoord_4.xyz);
    OUT.color_0.a = (AlphaTestRef.x >= r0.w ? 0 : IN.texcoord_5.w);
    OUT.color_0.rgb = (r0.xyz * q2.xyz) + ((IN.color_0.rgb - (r0.xyz * q2.xyz)) * IN.color_0.a);
   
    return OUT;
};

// approximately 19 instruction slots used (3 texture, 16 arithmetic)
