//
// Generated by Microsoft (R) D3DX9 Shader Compiler 9.08.299.0000
//
//   vsa shaderdump19/HDR006.pso /Fcshaderdump19/HDR006.pso.dis
//
//
// Parameters:
//
float4 TimingData : register(c0);
float4 HDRParam : register(c1);
float4 TESR_ToneMapping : register(c19);

sampler2D ScreenSpace : register(s0);
sampler2D AvgLum : register(s1);
//
// Registers:
//
//   Name         Reg   Size
//   ------------ ----- ----
//   TimingData   const_0       1
//   HDRParam     const_1       1
//   ScreenSpace         texture_0       1
//   AvgLum       texture_1       1
//

#include "Includes/Color.hlsl"

// Structures:

struct VS_OUTPUT {
    float2 ScreenOffset : TEXCOORD0;
};

struct PS_OUTPUT {
    float4 color_0 : COLOR0;
};

// Code:

PS_OUTPUT main(VS_OUTPUT IN) {
    PS_OUTPUT OUT;

    float lower, upper, range;
    float3 color, avlum;

    color = tex2D(ScreenSpace, IN.ScreenOffset.xy).rgb;
    avlum = tex2D(AvgLum     , IN.ScreenOffset.xy).rgb;
	
	color = pow(abs(color), TESR_ToneMapping.w);
    color = lerp(color, avlum, 1.0 - pow(abs(HDRParam.z), TimingData.z));
    lower = max(0.01, GetLuminance(color));
    upper = min(lower, HDRParam.w);
    range = (upper / lower);
	color = pow(abs(color), 1.0 / TESR_ToneMapping.w);
	
    OUT.color_0.a = 1;
    OUT.color_0.rgb = color * range;

    return OUT;
};

// approximately 19 instruction slots used (2 texture, 17 arithmetic)
