float4 AmbientColor : register(c1);
sampler2D BaseMap : register(s0);
sampler2D NormalMap : register(s1);
float4 PSLightColor[4] : register(c2);
sampler2D ShadowMap : register(s2);
float4 TESR_TerrainData : register(c8);
sampler2D TESR_samplerNoise : register(s10) < string ResourceName = "Effects\TerrainNoise_n.dds"; > = sampler_state { ADDRESSU = WRAP; ADDRESSV = WRAP; MAGFILTER = LINEAR; MINFILTER = MINDEF; MIPFILTER = MIPDEF; };
//
//
// Registers:
//
//   Name         Reg   Size
//   ------------ ----- ----
//   AmbientColor const_1       1
//   PSLightColor[0] const_2        1
//   BaseMap      texture_0       1
//   NormalMap    texture_1       1
//   ShadowMap    texture_2       1
//


// Structures:

struct VS_OUTPUT {
    float2 BaseUV : TEXCOORD0;
    float2 NormalUV : TEXCOORD1;
    float4 texcoord_2 : TEXCOORD2_centroid;
    float3 texcoord_3 : TEXCOORD3_centroid;
};

struct PS_OUTPUT {
    float4 color_0 : COLOR0;
};

// Code:

PS_OUTPUT main(VS_OUTPUT IN) {
    PS_OUTPUT OUT;

#define	expand(v)		(((v) - 0.5) / 0.5)
#define	compress(v)		(((v) * 0.5) + 0.5)
#define	shade(n, l)		max(dot(n, l), 0)
#define	shades(n, l)		saturate(dot(n, l))

    float3 q0;
    float4 r0;
    float4 r1;
      

    r1.xyzw = tex2D(NormalMap, IN.NormalUV.xy);
    r0.xyzw = tex2D(BaseMap, IN.BaseUV.xy);
    
    
    float3 noisen = expand(tex2D(TESR_samplerNoise, IN.BaseUV.xy * TESR_TerrainData.y).xyz);
    r1.xyz = (r1.xyz + float3(noisen.xy * TESR_TerrainData.z, 0));
    
    q0.xyz = (shades(normalize(expand(r1.xyz)), IN.texcoord_3.xyz) * PSLightColor[0].rgb) + AmbientColor.rgb;
    r1.xyz = q0.xyz * (r0.xyz * IN.texcoord_2.xyz);
  
    float3 noisec = (tex2D(ShadowMap, IN.BaseUV.xy * TESR_TerrainData.x).xyz * 2 + tex2D(ShadowMap, IN.BaseUV.xy * (TESR_TerrainData.x / 10)).xyz) * 0.3333;
    r0.x   = saturate(0.50 + 1.25 * (smoothstep(1.0, 0.0, pow(noisec.x, 0.5))));
    r0.xyz = lerp(r0.x, 1, pow(length(r0.rgb) / length(1), 2));
    
    OUT.color_0.a = IN.texcoord_2.w;
    OUT.color_0.rgb = r1.xyz * (r0.x);   
 
    return OUT;
};