//
// Generated by Microsoft (R) D3DX9 Shader Compiler 9.08.299.0000
//
// Parameters:
//
int fResolution : register(c2);
float4 TESR_GameTime : register(c3);
float4 TESR_WaveParams : register(c4);
float4 TESR_RainData : register(c5);

sampler2D amplitudeSamp : register(s0);
sampler3D TESR_Water : register(s1) < string ResourceName = "Water\water_NRM.dds"; > = sampler_state { ADDRESSU = WRAP; ADDRESSV = WRAP; ADDRESSW = WRAP; MAGFILTER = LINEAR; MINFILTER = LINEAR; MIPFILTER = NONE; };
sampler2D TESR_RippleSampler : register(s2) < string ResourceName = "Precipitations\ripples.dds"; > = sampler_state { ADDRESSU = WRAP; ADDRESSV = WRAP; MAGFILTER = LINEAR; MINFILTER = LINEAR; MIPFILTER = LINEAR; };

static const float PI = 3.14159265;
static const float time1 = frac(TESR_GameTime.z * 0.90f);
static const float time2 = frac(TESR_GameTime.z * 1.10f);
static const float time3 = frac(TESR_GameTime.z * 1.20f);
static const float time4 = frac(TESR_GameTime.z * 1.25f);
static const float time5 = frac(TESR_GameTime.z * 0.55f);
static const float time6 = frac(TESR_GameTime.z * 0.80f);
static const float time7 = frac(TESR_GameTime.z * 1.50f);
static const float time8 = frac(TESR_GameTime.z * 0.70f);

//
//
// Registers:
//
//   Name          Reg   Size
//   ------------- ----- ----
//   fResolution   const_2       1
//   amplitudeSamp texture_0       1
//


// Structures:

struct VS_OUTPUT {
    float2 texcoord_0 : TEXCOORD0;
};

struct PS_OUTPUT {
    float4 color_0 : COLOR0;
};

// Code:
float2 ComputeRipple(float2 UV, float CurrentTime, float Weight) {
	
    float4 Ripple = tex2D(TESR_RippleSampler, UV);
    Ripple.yz = Ripple.yz * 2 - 1;

    float DropFrac = frac(Ripple.w + CurrentTime);
    float TimeFrac = DropFrac - 1.0f + Ripple.x;
    float DropFactor = saturate(0.2f + Weight * 0.6f - DropFrac);
    float FinalFactor = DropFactor * Ripple.x * sin(clamp(TimeFrac * 9.0f, 0.0f, 3.0f) * PI);
    return float2(Ripple.yz * FinalFactor * 0.35f);
	
}

PS_OUTPUT main(VS_OUTPUT IN) {
    PS_OUTPUT OUT;
	
    float frame = TESR_GameTime.z * TESR_WaveParams.z;
    float4 HeightMap = tex3D(TESR_Water, float3(IN.texcoord_0.xy, frac(frame)));
	float4 RippleMap = float4(0, 0, 0, 0);
	
	if (TESR_RainData.x > 0.0f) {
		float4 Weights = float4(1, 0.75, 0.5, 0.25) * TESR_RainData.x;
		Weights = saturate(Weights * 4);
		
		float2 Ripple1 = ComputeRipple(IN.texcoord_0.xy * 1.10f, time1, Weights.x);
		float2 Ripple2 = ComputeRipple(IN.texcoord_0.xy * 1.25f, time2, Weights.y);
		float2 Ripple3 = ComputeRipple(IN.texcoord_0.xy * 1.50f, time3, Weights.z);
		float2 Ripple4 = ComputeRipple(IN.texcoord_0.xy * 1.75f, time4, Weights.w);
		
		float2 Ripple5 = ComputeRipple(IN.texcoord_0.xy * 1.70f, time5, Weights.x);
		float2 Ripple6 = ComputeRipple(IN.texcoord_0.xy * 1.80f, time6, Weights.y);
		float2 Ripple7 = ComputeRipple(IN.texcoord_0.xy * 1.90f, time7, Weights.z);
		float2 Ripple8 = ComputeRipple(IN.texcoord_0.xy * 2.00f, time8, Weights.w);
		
		RippleMap = float4(Weights.x * Ripple1.xy + Weights.y * Ripple2.xy + Weights.z * Ripple3.xy + Weights.w * Ripple4.xy, 0, 0);
		RippleMap += float4(Weights.x * Ripple5.xy + Weights.y * Ripple6.xy + Weights.z * Ripple7.xy + Weights.w * Ripple8.xy, 0, 0);
	}
	
	OUT.color_0 = HeightMap + RippleMap;
    return OUT;
	
};