// =========================================
//  LIFTGAMMAGAIN
// =========================================

float4 TESR_LiftGammaGain_LiftR; //[0.000:2.000]
float4 TESR_LiftGammaGain_LiftG; //[0.000:2.000]
float4 TESR_LiftGammaGain_LiftB; //[0.000:2.000]
float4 TESR_LiftGammaGain_GammaR; //[0.000:2.000]
float4 TESR_LiftGammaGain_GammaG; //[0.000:2.000]
float4 TESR_LiftGammaGain_GammaB; //[0.000:2.000]
float4 TESR_LiftGammaGain_GainR; //[0.000:2.000]
float4 TESR_LiftGammaGain_GainG; //[0.000:2.000]
float4 TESR_LiftGammaGain_GainB; //[0.000:2.000]
static const float3 RGB_Lift = float3( TESR_LiftGammaGain_LiftR.r, TESR_LiftGammaGain_LiftG.r, TESR_LiftGammaGain_LiftB.r );
static const float3 RGB_Gamma = float3( TESR_LiftGammaGain_GammaR.r, TESR_LiftGammaGain_GammaG.r, TESR_LiftGammaGain_GammaB.r );
static const float3 RGB_Gain = float3( TESR_LiftGammaGain_GainR.r, TESR_LiftGammaGain_GainG.r, TESR_LiftGammaGain_GainB.r );

sampler2D TESR_RenderedBuffer : register(s0) = sampler_state {
	AddressU  = CLAMP;
	AddressV  = CLAMP;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
};

struct VSOUT {
	float4 vertPos : POSITION;
	float2 UVCoord : TEXCOORD0;
};

struct VSIN {
	float4 vertPos : POSITION0;
	float2 UVCoord : TEXCOORD0;
};

VSOUT FrameVS(VSIN IN) {
	VSOUT OUT = (VSOUT)0.0f;
	OUT.vertPos = IN.vertPos;
	OUT.UVCoord = IN.UVCoord;
	return (OUT);
}

float4 LiftGammaGainPass( VSOUT IN ) : COLOR0 {

	float4 colorInput = tex2D( TESR_RenderedBuffer, IN.UVCoord );
	float3 color = colorInput.rgb;
	color = color * ( 1.5 - 0.5 * RGB_Lift.xyz ) + 0.5 * RGB_Lift.xyz - 0.5;
	color = saturate( color );
	color *= RGB_Gain.xyz; 
	colorInput.rgb = pow( color, 1.0 / RGB_Gamma.xyz );

	return float4( saturate( colorInput.rgb ), 1 );
}

technique {
	pass {
		VertexShader = compile vs_3_0 FrameVS();
		PixelShader = compile ps_3_0 LiftGammaGainPass();
	}
}