// Perfect Perspective by Jacob Maximilian Fober, for more info see PerfectPerspective.fxh
// Letterbox code by Matso

#define USE_LETTERBOX	0
#define LETTERBOX_SIZE	6
float4 TESR_ZX; //[0.000:5.000]
float4x4 TESR_ProjectionTransform; 
float4 TESR_ReciprocalResolution;

sampler2D TESR_RenderedBuffer : register(s0) = sampler_state
{
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	AddressU = MIRROR;
	AddressV = MIRROR;
	SRGBTexture = FALSE;
	MaxMipLevel = 0;
	MipMapLodBias = 0;
};

struct VSOUT
{
	float4 vertPos : POSITION;
	float2 UVCoord : TEXCOORD0;
};
 
struct VSIN
{
	float4 vertPos : POSITION0;
	float2 UVCoord : TEXCOORD0;
};
 
VSOUT FrameVS(VSIN IN)
{
	VSOUT OUT = (VSOUT)0.0f;
	OUT.vertPos = IN.vertPos;
	OUT.UVCoord = IN.UVCoord;
	return OUT;
}

#include "PerfectPerspective.fxh"

float4 PS_Apply_PerfectPerspective(VSOUT IN) : COLOR0
{
	float4 color; 
  
	
	float FOVH = TESR_ZX * degrees(atan(1 / TESR_ProjectionTransform._22));
	
	PerfectPerspectiveStruct val;
	val.bUseBorder = false;
	val.bDebug = false;
	val.type = 0;
	val.FOV = FOVH;
	val.vertical = 0.318;
	val.resScale = 0.5;
	val.zooming = 1.0;
	val.aspectR = TESR_ReciprocalResolution.z;
	val.pixSize = TESR_ReciprocalResolution.xy;
	val.color = float4(0.027, 0.027, 0.027, 0.0);
	
	color.rgb = applyPerfectPerspective(TESR_RenderedBuffer, IN.UVCoord, val);
	
	
	color.a = 1.0f;
	
	return color;
}

technique
{
	pass
	{
		VertexShader = compile vs_3_0 FrameVS();
		PixelShader  = compile ps_3_0 PS_Apply_PerfectPerspective();
	}
}