//
// Generated by Microsoft (R) D3DX9 Shader Compiler 9.08.299.0000
//
//   vsa shaderdump19/HDR004.pso /Fcshaderdump19/HDR004.pso.dis
//
//
// Parameters:
//
float4 HDRParam : register(c1);
float4 TESR_ToneMapping : register(c19);

sampler2D ScreenSpace : register(s0);
sampler2D DestBlend : register(s1);
sampler2D AvgLum : register(s2);

//
// Registers:
//
//   Name         Reg   Size
//   ------------ ----- ----
//   HDRParam     const_1       1
//   ScreenSpace         texture_0       1
//   DestBlend    texture_1       1
//   AvgLum       texture_2       1
//

#include "Includes/Color.hlsl"

// Structures:

struct VS_OUTPUT {
    float2 ScreenOffset : TEXCOORD0;
    float2 texcoord_1 : TEXCOORD1;
};

struct PS_OUTPUT {
    float4 color_0 : COLOR0;
};

// Code:

PS_OUTPUT main(VS_OUTPUT IN) {
    PS_OUTPUT OUT;

#define	weight(v)		dot(v, 1)

    float3 reslt;
    float3 color;
    float3 avlum;
    float3 blurc;
    float rwhite;
    float whitef;
    float luma, lumc, amplify;

    blurc = tex2D(ScreenSpace, IN.ScreenOffset.xy).rgb;
    color = tex2D(DestBlend, IN.texcoord_1.xy).rgb;
    avlum = tex2D(AvgLum, IN.ScreenOffset.xy).rgb;

    avlum = max(0.05, avlum);
	luma = GetLuminance(avlum);
    whitef = HDRParam.x / max(luma, HDRParam.x);
    blurc = blurc * (whitef * GetWhitePoint() * TESR_ToneMapping.y);
    color = color * (whitef * GetWhitePoint() * TESR_ToneMapping.z);
    reslt = blurc + color;
	
    luma = GetLuminance(avlum);
    lumc = GetLuminance(reslt);
    amplify = log(2.2 + 4.2 * luma + TESR_ToneMapping.x + min(lumc * 64.0, (0.001 / pow(luma, 2.2)))) / log(2.2 + 4.2 * luma + TESR_ToneMapping.x + lumc);
    reslt *= amplify;

    luma = GetLuminance(avlum);
    lumc = GetLuminance(reslt);
    reslt = lerp(lerp(BlueShift / 32, reslt * BlueShift / length(BlueShift), saturate(sqrt(luma) * 2)), reslt, saturate(sqrt(lumc) * 2));
	
    OUT.color_0.a = 1;
    OUT.color_0.rgb = reslt;

    return OUT;
};

// approximately 13 instruction slots used (3 texture, 10 arithmetic)