// 
// Generated by Microsoft (R) D3DX9 Shader Compiler 9.08.299.0000
//
//   vsa shaderdump19/PAR2002.pso /Fcshaderdump19/PAR2002.pso.dis
//
// 
// Parameters:
//
float4 AmbientColor : register(c1);
sampler2D TESR_samplerBaseMap : register(s0) = sampler_state { MINFILTER = LINEAR; };
sampler2D NormalMap : register(s1);
float4 PSLightColor[4] : register(c2);
sampler2D ShadowMap : register(s6);
sampler2D ShadowMaskMap : register(s7);
float4 Toggles : register(c7);
//
//
// Registers:
//
//   Name          Reg   Size
//   ------------- ----- ----
//   AmbientColor  const_1       1
//   PSLightColor[0]  const_2        1
//   Toggles       const_7       1
//   TESR_samplerBaseMap       texture_0       1
//   NormalMap     texture_1       1
//   ShadowMap     texture_6       1
//   ShadowMaskMap texture_7       1
//

// Structures:

struct VS_OUTPUT {
    // PAR2002.vso

    float2 BaseUV : TEXCOORD0;
    float3 Light0Dir : TEXCOORD1_centroid;
    float3 CameraDir : TEXCOORD6_centroid;
    float4 ShadowUV : TEXCOORD7;
    float3 Color : COLOR0;
    float4 Fog : COLOR1;
};

struct PS_OUTPUT {
    float4 Color : COLOR0;
};

// Code:

#include "Includes/PAR.hlsl"

PS_OUTPUT main(VS_OUTPUT IN) {
    PS_OUTPUT OUT;

#define	expand(v)		(((v) - 0.5) / 0.5)
#define	compress(v)		(((v) * 0.5) + 0.5)
#define	uvtile(w)		(((w) * 0.04) - 0.02)
#define	shade(n, l)		max(dot(n, l), 0)
#define	shades(n, l)		saturate(dot(n, l))

    float3 q4;
    float3 q5;
    float3 q6;
    float3 q7;
    float4 r0;
    float4 r3;
    float3 nm;
    float3 t0;
    float1 t1;
    float2 uv;
    float  ao;
    float  hg;
    float3 cm = normalize(IN.CameraDir);

    /* calculate parallaxed position */
    hg = tex2D(TESR_samplerBaseMap, IN.BaseUV.xy).a;
    uv.xy = (uvtile(hg) * (cm.xy / length(cm.xyz))) + IN.BaseUV.xy;
    ao = 1.0;

    /* modifying shader --------------------------------------- */

    psParallax(IN, uv, ao);

    /* fetch Base/Normal from parallaxed position */
    r0.rgb = tex2D(TESR_samplerBaseMap, uv.xy).rgb;
    nm.xyz = expand(tex2D(NormalMap, uv.xy).xyz);

    t1.x   = tex2D(ShadowMaskMap, IN.ShadowUV.zw).x;
    t0.xyz = tex2D(ShadowMap, IN.ShadowUV.xy).xyz;

    r3.xyz = shades(normalize(nm.xyz), IN.Light0Dir.xyz) * PSLightColor[0].rgb;
    q4.xyz = max((((t1.x * (t0.xyz - 1)) + 1) * r3.xyz) + AmbientColor.rgb, 0);
    q5.xyz = (Toggles.x <= 0.0 ? r0.xyz : (r0.xyz * IN.Color.rgb));
    q6.xyz = q5.xyz * q4.xyz * ao;
    q7.xyz = (Toggles.y <= 0.0 ? q6.xyz : ((IN.Fog.a * (IN.Fog.rgb - q6.xyz)) + q6.xyz));

    OUT.Color.a = AmbientColor.a;
    OUT.Color.rgb = q7.xyz;

    return OUT;
};

// approximately 31 instruction slots used (5 texture, 26 arithmetic)
