//
// Generated by Microsoft (R) D3DX9 Shader Compiler 9.08.299.0000
//
//   vsa shaderdump19/PAR2018.pso /Fcshaderdump19/PAR2018.pso.dis
//
//
// Parameters:
//
float4 AmbientColor : register(c1);
sampler2D AttenuationMap : register(s4);
sampler2D TESR_samplerBaseMap : register(s0) = sampler_state { MINFILTER = LINEAR; };
sampler2D NormalMap : register(s1);
float4 PSLightColor[4] : register(c2);
sampler2D ShadowMap : register(s5);
sampler2D ShadowMaskMap : register(s6);
//
//
// Registers:
//
//   Name           Reg   Size
//   -------------- ----- ----
//   AmbientColor   const_1       1
//   PSLightColor[0]   const_2        1
//   PSLightColor[1]   const_3        1
//   PSLightColor[2]   const_4        1
//   TESR_samplerBaseMap        texture_0       1
//   NormalMap      texture_1       1
//   AttenuationMap texture_4       1
//   ShadowMap      texture_5       1
//   ShadowMaskMap  texture_6       1
//

// Structures:

struct VS_OUTPUT {
    // PAR2022.vso

    float2 BaseUV : TEXCOORD0;
    float3 Light0Dir : TEXCOORD1_centroid;
    float3 Light1Dir : TEXCOORD2_centroid;
    float3 Light2Dir : TEXCOORD3_centroid;
    float4 Att1UV : TEXCOORD4;
    float4 Att0UV : TEXCOORD5;
    float3 CameraDir : TEXCOORD7_centroid;
    float4 ShadowUV : TEXCOORD6;
};

struct PS_OUTPUT {
    float4 Color : COLOR0;
};

// Code:

#include "includes/PAR.hlsl"

PS_OUTPUT main(VS_OUTPUT IN) {
    PS_OUTPUT OUT;

#define	expand(v)		(((v) - 0.5) / 0.5)
#define	compress(v)		(((v) * 0.5) + 0.5)
#define	uvtile(w)		(((w) * 0.04) - 0.02)
#define	shade(n, l)		max(dot(n, l), 0)
#define	shades(n, l)		saturate(dot(n, l))

    float1 att0;
    float1 att14;
    float1 att6;
    float1 att7;
    float3 q2;
    float3 q21;
    float4 r0;
    float3 r1;
    float3 r2;
    float3 r3;
    float  a0;
    float  a1;
    float3 nm;
    float3 t1;
    float1 t3;
    float2 uv;
    float  ao;
    float  hg;
    float3 cm = normalize(IN.CameraDir);

    /* calculate parallaxed position */
    hg = tex2D(TESR_samplerBaseMap, IN.BaseUV.xy).a;
    uv.xy = (uvtile(hg) * (cm.xy / length(cm.xyz))) + IN.BaseUV.xy;
    ao = 1.0;

    /* modifying shader --------------------------------------- */

    psParallax(IN, uv, ao);

    /* fetch Normal from parallaxed position */
    nm.xyz = tex2D(NormalMap, uv.xy).xyz;

    /* fetch additional unmodified Shadow/Attenuation */
    t3.x = tex2D(ShadowMaskMap, IN.ShadowUV.zw).x;
    t1.xyz = tex2D(ShadowMap, IN.ShadowUV.xy).xyz;
    att7.x = tex2D(AttenuationMap, IN.Att0UV.zw).x;
    att6.x = tex2D(AttenuationMap, IN.Att0UV.xy).x;
    att14.x = tex2D(AttenuationMap, IN.Att1UV.zw).x;
    att0.x = tex2D(AttenuationMap, IN.Att1UV.xy).x;

    a0 = saturate((1 - att0.x) - att14.x);
    a1 = saturate((1 - att6.x) - att7.x);
    q2.xyz = normalize(expand(nm.xyz));
    r0.xyz = shades(q2.xyz, normalize(IN.Light2Dir.xyz)) * PSLightColor[2].rgb;
    r1.xyz = shades(q2.xyz, normalize(IN.Light1Dir.xyz)) * PSLightColor[1].rgb;
    r2.xyz = shades(q2.xyz, IN.Light0Dir.xyz) * PSLightColor[0].rgb;
    r3.xyz = (t3.x * (t1.xyz - 1)) + 1;
    q21.xyz = (r3.xyz * r2.xyz) + (a0 * r1.xyz);

    OUT.Color.a = 1;
    OUT.Color.rgb = ((a1 * r0.xyz) + q21.xyz + AmbientColor.rgb) * ao;

    return OUT;
};

// approximately 48 instruction slots used (8 texture, 40 arithmetic)
