//
// Generated by Microsoft (R) D3DX9 Shader Compiler 9.08.299.0000
//
//   vsa shaderdump19/PAR2025.pso /Fcshaderdump19/PAR2025.pso.dis
//
//
// Parameters:
//
sampler2D AttenuationMap : register(s3);
sampler2D TESR_samplerBaseMap : register(s1) = sampler_state { MINFILTER = LINEAR; };
sampler2D NormalMap : register(s0);
float4 PSLightColor[4] : register(c2);
float4 Toggles : register(c7);
//
//
// Registers:
//
//   Name           Reg   Size
//   -------------- ----- ----
//   PSLightColor[0]   const_2        1
//   Toggles        const_7        1
//   NormalMap      texture_0       1
//   TESR_samplerBaseMap        texture_1       1
//   AttenuationMap texture_3       1
//

// Structures:

struct VS_OUTPUT {
    float2 BaseUV : TEXCOORD0;
    float3 Light0Dir : TEXCOORD1_centroid;
    float3 Light0Spc : TEXCOORD3_centroid;
    float4 Att0UV : TEXCOORD5;
    float3 CameraDir : TEXCOORD7_centroid;
};

struct PS_OUTPUT {
    float4 Color : COLOR0;
};

// Code:

#include "includes/PAR.hlsl"

PS_OUTPUT main(VS_OUTPUT IN) {
    PS_OUTPUT OUT;

#define	expand(v)		(((v) - 0.5) / 0.5)
#define	compress(v)		(((v) * 0.5) + 0.5)
#define	uvtile(w)		(((w) * 0.04) - 0.02)
#define	shade(n, l)		max(dot(n, l), 0)
#define	shades(n, l)		saturate(dot(n, l))
#define	weight(v)		dot(v, 1)
#define	sqr(v)			((v) * (v))

    float1 att2;
    float1 att3;
    float1 q1;
    float1 q12;
    float3 q13;
    float4 r0;
    float4 r2;
    float  a0;
    float2 uv;
    float  ao;
    float  hg;
    float3 cm = normalize(IN.CameraDir);

    /* calculate parallaxed position */
    hg = tex2D(TESR_samplerBaseMap, IN.BaseUV.xy).a;
    uv.xy = (uvtile(hg) * (cm.xy / length(cm.xyz))) + IN.BaseUV.xy;
    ao = 1.0;

    /* modifying shader --------------------------------------- */

    psParallax(IN, uv, ao);

    /* fetch Normal+Diffuse from parallaxed position */
    r2.xyzw = tex2D(NormalMap, uv.xy);

    /* fetch additional unmodified Attenuation */
    att3.x = tex2D(AttenuationMap, IN.Att0UV.zw).x;
    att2.x = tex2D(AttenuationMap, IN.Att0UV.xy).x;

    a0 = saturate((1 - att2.x) - att3.x);
    q1.x = dot(normalize(expand(r2.xyz)), normalize(IN.Light0Dir.xyz));
    q12.x = r2.w * pow(abs(shades(normalize(expand(r2.xyz)), normalize(IN.Light0Spc.xyz))), Toggles.z);
    q13.xyz = saturate(a0 * ((0.2 >= q1.x ? (q12.x * max(q1.x + 0.5, 0)) : q12.x) * PSLightColor[0].rgb));

    OUT.Color.a = weight(q13.xyz);
    OUT.Color.rgb = q13.xyz * ao;

    return OUT;
};

// approximately 40 instruction slots used (4 texture, 36 arithmetic)
