
static const float BIAS = 0.0005f;
static const float xPixelOffset = 1.0f / TESR_ShadowData.w;
static const float yPixelOffset = 1.0f / TESR_ShadowData.w;

float Lookup(float4 vPosLight, float2 OffSet) {
	
	float shadow = tex2D(TESR_ShadowMapBuffer, vPosLight.xy + float2(OffSet.x * xPixelOffset, OffSet.y * yPixelOffset)).r;
	if (shadow < vPosLight.z - BIAS) return TESR_ShadowData.z;
	return 1;
	
}

float GetLightAmount(float4 vPosLight) {
					
	float Shadow = 0.0f;
	float x;
	float y;
	
	vPosLight.xyz /= vPosLight.w;
    if (vPosLight.x < -1.0f || vPosLight.x > 1.0f ||
        vPosLight.y < -1.0f || vPosLight.y > 1.0f ||
        vPosLight.z <  0.0f || vPosLight.z > 1.0f)
		return 1;
 
    vPosLight.x = vPosLight.x/2 + 0.5;
    vPosLight.y = vPosLight.y/-2 + 0.5;
	if (TESR_ShadowData.y == 0.0f) {
		for (y = -1.5; y <= 1.5; y += 1.0) {
			for (x = -1.5; x <= 1.5; x += 1.0) {
				Shadow += Lookup(vPosLight, float2(x, y));
			}
		}
		Shadow /= 16.0;
	}
	else if (TESR_ShadowData.y == 1.0f) {
		for (y = -1.0; y <= 1.0; y += 0.5) {
			for (x = -1.0; x <= 1.0; x += 0.5) {
				Shadow += Lookup(vPosLight, float2(x, y));
			}
		}
		Shadow /= 25.0;
	}
	else {
		for (y = -3.5; y <= 3.5; y += 1.0) {
			for (x = -3.5; x <= 3.5; x += 1.0) {
				Shadow += Lookup(vPosLight, float2(x, y));
			}
		}
		Shadow /= 64.0;
	}
	return Shadow;
	
}

float GetLightAmountSkin(float4 vPosLight) {
					
	float Shadow = 0.0f;
	float x;
	float y;
	
	vPosLight.xyz /= vPosLight.w;
    if (vPosLight.x < -1.0f || vPosLight.x > 1.0f ||
        vPosLight.y < -1.0f || vPosLight.y > 1.0f ||
        vPosLight.z <  0.0f || vPosLight.z > 1.0f)
		return 1;
 
    vPosLight.x = vPosLight.x/2 + 0.5;
    vPosLight.y = vPosLight.y/-2 + 0.5;

	for (y = -0.1; y <= 0.1; y += 0.05) {
		for (x = -0.1; x <= 0.1; x += 0.05) {
			Shadow += Lookup(vPosLight, float2(x, y));
		}
	}
	Shadow /= 25.0;
	return Shadow;
	
}