//
// Generated by Microsoft (R) D3DX9 Shader Compiler 9.08.299.0000
//
//   vsa shaderdump19/SKIN2003.pso /Fcshaderdump19/SKIN2003.pso.dis
//
//
// Parameters:
//
float4 AmbientColor : register(c1);
float4 PSLightColor[4] : register(c2);
float4 Toggles : register(c7);
float4 TESR_SkinData : register(c8);
float4 TESR_SkinColor : register(c9);
float4 TESR_ShadowData : register(c10);

sampler2D BaseMap : register(s0);
sampler2D NormalMap : register(s1);
sampler2D FaceGenMap0 : register(s2);
sampler2D FaceGenMap1 : register(s3);
sampler2D AttenuationMap : register(s5);
sampler2D ShadowMap : register(s6);
sampler2D ShadowMaskMap : register(s7);
sampler2D TESR_ShadowMapBuffer : register(s8) = sampler_state { ADDRESSU = CLAMP; ADDRESSV = CLAMP; MAGFILTER = LINEAR; MINFILTER = LINEAR; MIPFILTER = LINEAR; };
//
//
// Registers:
//
//   Name           Reg   Size
//   -------------- ----- ----
//   AmbientColor   const_1       1
//   PSLightColor[0]   const_2        1
//   PSLightColor[1]   const_3        1
//   Toggles        const_7       1
//   BaseMap        texture_0       1
//   NormalMap      texture_1       1
//   FaceGenMap0    texture_2       1
//   FaceGenMap1    texture_3       1
//   AttenuationMap texture_5       1
//   ShadowMap      texture_6       1
//   ShadowMaskMap  texture_7       1
//


// Structures:

struct VS_OUTPUT {
    float2 BaseUV : TEXCOORD0;
    float3 Light0Dir : TEXCOORD1_centroid;
    float3 Light1Dir : TEXCOORD2_centroid;
    float4 Att1UV : TEXCOORD4;
    float3 CameraDir : TEXCOORD6_centroid;
    float4 ShadowUV : TEXCOORD7;
    float3 Color : COLOR0;
    float4 Fog : COLOR1;
};

struct PS_OUTPUT {
    float4 Color : COLOR0;
};

// Code:

#include "includes/Skin.hlsl"
#include "../Shadows/Includes/Shadow.hlsl"

PS_OUTPUT main(VS_OUTPUT IN) {
    PS_OUTPUT OUT;

#define	expand(v)		(((v) - 0.5) / 0.5)
#define	compress(v)		(((v) * 0.5) + 0.5)
#define	shade(n, l)		max(dot(n, l), 0)
#define	shades(n, l)		saturate(dot(n, l))
#define	weight(v)		dot(v, 1)
#define	sqr(v)			((v) * (v))

    float att23;
    float att4;
	float q6;
	float q7;
    float3 norm;
	float3 camera;
    float3 q10;
    float3 q11;
    float3 q12;
    float3 q13;
    float3 q14;
    float3 q27;
    float3 q9;
    float4 r0;
    float3 r1;
    float3 r2;
    float3 r5;
    
    norm = normalize(expand(tex2D(NormalMap, IN.BaseUV.xy).xyz));
    r2 = tex2D(FaceGenMap1, IN.BaseUV.xy).rgb;
    r1 = tex2D(FaceGenMap0, IN.BaseUV.xy).rgb;
    r0 = tex2D(BaseMap, IN.BaseUV.xy);
    att4 = tex2D(AttenuationMap, IN.Att1UV.xy).x;
    att23 = tex2D(AttenuationMap, IN.Att1UV.zw).x;
	camera = normalize(IN.CameraDir.xyz);
	q27 = 2 * ((2 * r2) * (expand(r1) + r0.xyz));
    q6 = 1 - shade(norm, camera);
    q7 = q6 * sqr(q6);
	q11.xyz = (shade(norm.xyz,           IN.Light0Dir.xyz ) * PSLightColor[0].rgb) + ((q7.x * PSLightColor[0].rgb) * 0.5);
    q10.xyz = (shade(norm.xyz, normalize(IN.Light1Dir.xyz)) * PSLightColor[1].rgb) + ((q7.x * PSLightColor[1].rgb) * 0.5);
    
    q11 = psSkin(q11, PSLightColor[0].rgb, camera, IN.Light0Dir.xyz, norm);
    q10 = psSkin(q10, PSLightColor[1].rgb, camera, IN.Light1Dir.xyz, norm);

    r5  = saturate(1 - att4 - att23) * q10;
    r5 += GetLightAmountSkin(IN.ShadowUV) * q11;
    q12 = max(r5 + AmbientColor.rgb, 0);
    q9 = (Toggles.x <= 0.0 ? q27 : (q27 * IN.Color.rgb));
    q13 = q12 * q9;
    q14 = (Toggles.y <= 0.0 ? q13 : ((IN.Fog.a * (IN.Fog.rgb - (q9 * q12))) + q13));
    OUT.Color.a = r0.w * AmbientColor.a;
    OUT.Color.rgb = q14;

    return OUT;
};

// approximately 59 instruction slots used (8 texture, 51 arithmetic)
