//
// Generated by Microsoft (R) D3DX9 Shader Compiler 9.08.299.0000
//
//   vsa shaderdump19/PAR2010.vso /Fcshaderdump19/PAR2010.vso.dis
//
//
// Parameters:
//
float4 EyePosition : register(c25);
float3 FogColor : register(c24);
float4 FogParam : register(c23);
float3 LightDirection[3] : register(c13);
row_major float4x4 ModelViewProj : register(c0);
row_major float4x4 ShadowProj : register(c28);
float4 ShadowProjData : register(c32);
float4 ShadowProjTransform : register(c33);
row_major float4x4 TESR_ShadowCameraToLightTransform[2] : register(c34);
//
//
// Registers:
//
//   Name                Reg   Size
//   ------------------- ----- ----
//   ModelViewProj[0]       const_0        1
//   ModelViewProj[1]       const_1        1
//   ModelViewProj[2]       const_2        1
//   ModelViewProj[3]       const_3        1
//   LightDirection[0]      const_13       1
//   FogParam            const_23      1
//   FogColor            const_24      1
//   EyePosition         const_25      1
//   ShadowProj[0]          const_28       1
//   ShadowProj[1]          const_29       1
//   ShadowProj[2]          const_30       1
//   ShadowProj[3]          const_31       1
//   ShadowProjData      const_32      1
//   ShadowProjTransform const_33      1
//

// Structures:

struct VS_INPUT {
    float4 Position : POSITION;
    float3 Tangent : TANGENT;
    float3 BiNormal : BINORMAL;
    float3 Normal : NORMAL;
    float4 BaseUV : TEXCOORD0;
    float4 Color : COLOR0;

#define	TanSpaceProj	float3x3(IN.Tangent.xyz, IN.BiNormal.xyz, IN.Normal.xyz)
};

struct VS_OUTPUT {
    // PAR2010.pso

    float4 Color : COLOR0;
    float4 Fog : COLOR1;
    float4 Position : POSITION;
    float2 BaseUV : TEXCOORD0;
    float3 Light0Dir : TEXCOORD1;
    float3 Light0Spc : TEXCOORD3;
    float3 CameraDir : TEXCOORD5;
	float4 ShadowUV0 : TEXCOORD6;
    float4 ShadowUV1 : TEXCOORD7;
};

// Code:

VS_OUTPUT main(VS_INPUT IN) {
    VS_OUTPUT OUT;

    /* original shader --------------------------------------- */

    float3 eye1;
    float3 spc0;
    float4 mdl;

    mdl = mul(ModelViewProj, IN.Position);

    eye1.xyz = EyePosition.xyz - IN.Position.xyz;
    spc0.xyz = normalize(eye1.xyz) + LightDirection[0].xyz;
    OUT.Color.rgba = IN.Color.rgba;
    OUT.Fog.a = 1 - saturate((FogParam.x - length(mdl.xyz)) / FogParam.y);
    OUT.Fog.rgb = FogColor.rgb;
    OUT.Position = mdl;
    OUT.Light0Dir.xyz = normalize(mul(TanSpaceProj, LightDirection[0].xyz));
    OUT.Light0Spc.xyz = normalize(mul(TanSpaceProj, spc0.xyz));
    OUT.CameraDir.xyz = mul(TanSpaceProj, eye1.xyz);
    OUT.BaseUV.xy = IN.BaseUV.xy;
    OUT.ShadowUV0 = mul(mdl, TESR_ShadowCameraToLightTransform[0]);
	OUT.ShadowUV1 = mul(mdl, TESR_ShadowCameraToLightTransform[1]);

    return OUT;
};

// approximately 57 instruction slots used
