//
// Generated by Microsoft (R) D3DX9 Shader Compiler 9.08.299.0000
//
//   vsa shaderdump19/PAR2034.vso /Fcshaderdump19/PAR2034.vso.dis
//
//
// Parameters:
//
float4 EyePosition : register(c25);
float4 LightPosition[3] : register(c16);
row_major float4x4 ModelViewProj : register(c0);
//
//
// Registers:
//
//   Name          Reg   Size
//   ------------- ----- ----
//   ModelViewProj[0] const_0        1
//   ModelViewProj[1] const_1        1
//   ModelViewProj[2] const_2        1
//   ModelViewProj[3] const_3        1
//   LightPosition[0] const_16       1
//   EyePosition   const_25      1
//

// Structures:

struct VS_INPUT {
    float4 Position : POSITION;
    float3 Tangent : TANGENT;
    float3 BiNormal : BINORMAL;
    float3 Normal : NORMAL;
    float4 BaseUV : TEXCOORD0;

#define	TanSpaceProj	float3x3(IN.Tangent.xyz, IN.BiNormal.xyz, IN.Normal.xyz)
};

struct VS_OUTPUT {
    float4 Position : POSITION;
    float2 BaseUV : TEXCOORD0;
    float3 Light0Dir : TEXCOORD1;
    float3 Light0Spc : TEXCOORD3;
    float4 Att0UV : TEXCOORD5;
    float3 CameraDir : TEXCOORD7;
};

// Code:

VS_OUTPUT main(VS_INPUT IN) {
    VS_OUTPUT OUT;

    /* original shader --------------------------------------- */

#define	expand(v)		(((v) - 0.5) / 0.5)
#define	compress(v)		(((v) * 0.5) + 0.5)

    float3 eye0;
    float3 lit0;
    float3 spc0;

    lit0.xyz = LightPosition[0].xyz - IN.Position.xyz;
    eye0.xyz = EyePosition.xyz - IN.Position.xyz;
    spc0.xyz = normalize(eye0.xyz) + normalize(lit0.xyz);

    OUT.Position.xyzw = mul(ModelViewProj, IN.Position.xyzw);
    OUT.Light0Dir.xyz = mul(TanSpaceProj, lit0.xyz);
    OUT.Light0Spc.xyz = mul(TanSpaceProj, spc0.xyz);
    OUT.CameraDir.xyz = mul(TanSpaceProj, eye0.xyz);

    OUT.BaseUV.xy = IN.BaseUV.xy;
    OUT.Att0UV.w = 0.5;
    OUT.Att0UV.xyz = compress(lit0.xyz / LightPosition[0].w);	// [-1,+1] to [0,1]

    OUT.Light0Dir.xyz = normalize(OUT.Light0Dir.xyz);
    OUT.Light0Spc.xyz = normalize(OUT.Light0Spc.xyz);

    return OUT;
};

// approximately 38 instruction slots used
