//
// Generated by Microsoft (R) D3DX9 Shader Compiler 9.08.299.0000
//
//   vsa shaderdump19/SKIN2000.pso /Fcshaderdump19/SKIN2000.pso.dis
//
//
// Parameters:
//
float4 AmbientColor : register(c1);
float4 PSLightColor[4] : register(c2);
float4 Toggles : register(c7);
float4 TESR_SkinData : register(c8);
float4 TESR_SkinColor : register(c9);

sampler2D BaseMap : register(s0);
sampler2D NormalMap : register(s1);
sampler2D FaceGenMap0 : register(s2);
sampler2D FaceGenMap1 : register(s3);
sampler2D AttenuationMap : register(s5);
sampler2D ShadowMap : register(s6);
sampler2D ShadowMaskMap : register(s7);
//
//
// Registers:
//
//   Name         Reg   Size
//   ------------ ----- ----
//   AmbientColor const_1       1
//   PSLightColor[0] const_2        1
//   Toggles      const_7       1
//   BaseMap      texture_0       1
//   NormalMap    texture_1       1
//   FaceGenMap0  texture_2       1
//   FaceGenMap1  texture_3       1
//


// Structures:

struct VS_OUTPUT {
    float2 BaseUV : TEXCOORD0;
    float3 Light0Dir : TEXCOORD1_centroid;
    float3 CameraDir : TEXCOORD6_centroid;
    float3 Color : COLOR0;
    float4 Fog : COLOR1;
};

struct PS_OUTPUT {
    float4 Color : COLOR0;
};

// Code:

#include "includes/Skin.hlsl"

PS_OUTPUT main(VS_OUTPUT IN) {
    PS_OUTPUT OUT;

#define	expand(v)		(((v) - 0.5) / 0.5)
#define	compress(v)		(((v) * 0.5) + 0.5)
#define	shade(n, l)		max(dot(n, l), 0)
#define	shades(n, l)		saturate(dot(n, l))
#define	weight(v)		dot(v, 1)
#define	sqr(v)			((v) * (v))

    float3 norm;
	float3 camera;
    float3 q0;
    float3 q11;
    float q4;
    float3 q6;
    float3 q8;
    float3 q9;
    float4 r0;
    float3 r1;
    float3 r2;
    float3 r3;

    norm = normalize(expand(tex2D(NormalMap, IN.BaseUV.xy).xyz));
    r2 = tex2D(FaceGenMap1, IN.BaseUV.xy).rgb;
    r1 = tex2D(FaceGenMap0, IN.BaseUV.xy).rgb;
    r0 = tex2D(BaseMap, IN.BaseUV.xy);
	camera = normalize(IN.CameraDir.xyz);
	
    q4 = 1 - shade(norm, camera);
    r3 = ((q4 * sqr(q4)) * PSLightColor[0].rgb) * 0.5;
    q6 = ((shade(norm, IN.Light0Dir.xyz) * PSLightColor[0].rgb) + r3) + AmbientColor.rgb;
    q11 = 2 * ((2 * r2) * (expand(r1) + r0.xyz));           

    q6  = psSkin(q6, PSLightColor[0].rgb, camera, IN.Light0Dir.xyz, norm) + AmbientColor.rgb;

    q0 = (Toggles.x <= 0.0 ? q11 : (q11 * IN.Color.rgb));
    q8 = max(q6, 0) * q0.xyz;
    q9 = (Toggles.y <= 0.0 ? q8 : ((IN.Fog.a * (IN.Fog.rgb - (q0 * max(q6, 0)))) + q8));

    OUT.Color.a = r0.w * AmbientColor.a;
    OUT.Color.rgb = q9;

    return OUT;
};

// approximately 37 instruction slots used (4 texture, 33 arithmetic)
