//
// Generated by Microsoft (R) D3DX9 Shader Compiler 9.08.299.0000
//
//   vsa shaderdump19/SKIN2004.pso /Fcshaderdump19/SKIN2004.pso.dis
//
//
// Parameters:
//
float4 AmbientColor : register(c1);
float4 PSLightColor[4] : register(c2);
float4 TESR_SkinData : register(c6);
float4 TESR_SkinColor : register(c7);

sampler2D BaseMap : register(s0);
sampler2D NormalMap : register(s1);
sampler2D AttenuationMap : register(s4);
//
//
// Registers:
//
//   Name           Reg   Size
//   -------------- ----- ----
//   AmbientColor   const_1       1
//   PSLightColor[0]   const_2        1
//   PSLightColor[1]   const_3        1
//   BaseMap        texture_0       1
//   NormalMap      texture_1       1
//   AttenuationMap texture_4       1
//


// Structures:

struct VS_OUTPUT {
    float2 BaseUV : TEXCOORD0;
    float3 Light0Dir : TEXCOORD1_centroid;
    float3 Light1Dir : TEXCOORD2_centroid;
    float4 Att1UV : TEXCOORD4;
    float3 CameraDir : TEXCOORD7_centroid;
};

struct PS_OUTPUT {
    float4 Color : COLOR0;
};

// Code:

#include "includes/Skin.hlsl"

PS_OUTPUT main(VS_OUTPUT IN) {
    PS_OUTPUT OUT;

#define	expand(v)		(((v) - 0.5) / 0.5)
#define	compress(v)		(((v) * 0.5) + 0.5)
#define	shade(n, l)		max(dot(n, l), 0)
#define	shades(n, l)		saturate(dot(n, l))
#define	weight(v)		dot(v, 1)
#define	sqr(v)			((v) * (v))

    float att3;
    float att9;
    float3 norm;
	float3 camera;
    float q5;
    float q6;
    float3 q7;
    float3 q8;
    float4 r0;

    norm = normalize(expand(tex2D(NormalMap, IN.BaseUV.xy).xyz));
    r0 = tex2D(BaseMap, IN.BaseUV.xy);
    att9 = tex2D(AttenuationMap, IN.Att1UV.zw).x;
    att3 = tex2D(AttenuationMap, IN.Att1UV.xy).x;
	camera = normalize(IN.CameraDir.xyz);
    q5 = 1 - shade(norm, camera);
    q6 = q5 * sqr(q5);
	q8 = (shade(norm,           IN.Light0Dir.xyz ) * PSLightColor[0].rgb) + ((q6 * PSLightColor[0].rgb) * 0.5);
    q7 = (shade(norm, normalize(IN.Light1Dir.xyz)) * PSLightColor[1].rgb) + ((q6 * PSLightColor[1].rgb) * 0.5);
    
    q8 = psSkin(q8, PSLightColor[0].rgb, camera, IN.Light0Dir.xyz, norm);
    q7 = psSkin(q7, PSLightColor[1].rgb, camera, IN.Light1Dir.xyz, norm);

    OUT.Color.a = r0.w;
    OUT.Color.rgb = ((saturate((1 - att3) - att9) * q7) + q8) + AmbientColor.rgb;

    return OUT;
};

// approximately 37 instruction slots used (4 texture, 33 arithmetic)
