//
// Generated by Microsoft (R) D3DX9 Shader Compiler 9.08.299.0000
//
//   vsa shaderdump19/SKIN2008.pso /Fcshaderdump19/SKIN2008.pso.dis
//
//
// Parameters:
//
float4 PSLightColor[4] : register(c2);
float4 TESR_SkinData : register(c6);
float4 TESR_SkinColor : register(c7);

sampler2D NormalMap : register(s0);
sampler2D AttenuationMap : register(s3);
//
//
// Registers:
//
//   Name           Reg   Size
//   -------------- ----- ----
//   PSLightColor[0]   const_2        1
//   PSLightColor[1]   const_3        1
//   NormalMap      texture_0       1
//   AttenuationMap texture_3       1
//


// Structures:

struct VS_OUTPUT {
    float2 NormalUV : TEXCOORD0;
    float3 Light0Dir : TEXCOORD1_centroid;
    float3 Light1Dir : TEXCOORD2_centroid;
    float4 Att1UV : TEXCOORD4;
    float4 Att2UV : TEXCOORD5;
    float3 CameraDir : TEXCOORD7_centroid;
};

struct PS_OUTPUT {
    float4 Color : COLOR0;
};

// Code:

#include "includes/Skin.hlsl"

PS_OUTPUT main(VS_OUTPUT IN) {
    PS_OUTPUT OUT;

#define	expand(v)		(((v) - 0.5) / 0.5)
#define	compress(v)		(((v) * 0.5) + 0.5)
#define	shade(n, l)		max(dot(n, l), 0)
#define	shades(n, l)		saturate(dot(n, l))
#define	weight(v)		dot(v, 1)
#define	sqr(v)			((v) * (v))

    float att11;
    float att6;
    float att7;
    float att8;
	float q4;
	float q5;
    float3 norm;
	float3 camera;
    float3 q12;
    float3 q13;
    float3 q9;

    norm = normalize(expand(tex2D(NormalMap, IN.NormalUV.xy).xyz));
	att11 = tex2D(AttenuationMap, IN.Att1UV.xy).x;
    att7 = tex2D(AttenuationMap, IN.Att1UV.zw).x;
    att6 = tex2D(AttenuationMap, IN.Att2UV.xy).x;
    att8 = tex2D(AttenuationMap, IN.Att2UV.zw).x;
	camera = normalize(IN.CameraDir.xyz);
    q4 = 1 - shade(norm, camera);
    q5 = q4 * sqr(q4);	
	q12 = (shade(norm, normalize(IN.Light0Dir.xyz)) * PSLightColor[0].rgb) + ((q5 * PSLightColor[0].rgb) * 0.5);
    q9  = (shade(norm, normalize(IN.Light1Dir.xyz)) * PSLightColor[1].rgb) + ((q5 * PSLightColor[1].rgb) * 0.5);
    
    q12 = psSkin(q12, PSLightColor[0].rgb, camera, IN.Light0Dir.xyz, norm);
    q9  = psSkin(q9, PSLightColor[1].rgb, camera, IN.Light1Dir.xyz, norm);
	
    q13  = saturate(1 - att11 - att7) * q12;
    q13 += saturate(1 - att6  - att8) * q9;

    OUT.Color.a = 1;
    OUT.Color.rgb = q13;

    return OUT;
};

// approximately 46 instruction slots used (5 texture, 41 arithmetic)
