//
// Generated by Microsoft (R) D3DX9 Shader Compiler 9.08.299.0000
//
//   vsa shaderdump19/SKIN2014.vso /Fcshaderdump19/SKIN2014.vso.dis
//
//
// Parameters:
//
float4 EyePosition : register(c25);
float3 LightDirection[3] : register(c13);
float4 LightPosition[3] : register(c16);
row_major float4x4 ModelViewProj : register(c0);
row_major float4x4 ShadowProj : register(c28);
float4 ShadowProjData : register(c32);
float4 ShadowProjTransform : register(c33);
row_major float4x4 TESR_ShadowCameraToLightTransform[2] : register(c34);
//
//
// Registers:
//
//   Name                Reg   Size
//   ------------------- ----- ----
//   ModelViewProj[0]       const_0        1
//   ModelViewProj[1]       const_1        1
//   ModelViewProj[2]       const_2        1
//   ModelViewProj[3]       const_3        1
//   LightDirection[0]      const_13       1
//   LightPosition[0]       const_16       1
//   LightPosition[1]       const_17       1
//   LightPosition[2]       const_18       1
//   EyePosition         const_25      1
//   ShadowProj[0]          const_28       1
//   ShadowProj[1]          const_29       1
//   ShadowProj[2]          const_30       1
//   ShadowProj[3]          const_31       1
//   ShadowProjData      const_32      1
//   ShadowProjTransform const_33      1
//


// Structures:

struct VS_INPUT {
    float4 Position : POSITION;
    float3 tangent : TANGENT;
    float3 binormal : BINORMAL;
    float3 normal : NORMAL;
    float4 BaseUV : TEXCOORD0;

#define	TanSpaceProj	float3x3(IN.tangent.xyz, IN.binormal.xyz, IN.normal.xyz)
};

struct VS_OUTPUT {
    float4 Position : POSITION;
    float2 BaseUV : TEXCOORD0;
    float4 Light0Dir : TEXCOORD1;
    float4 Light1Dir : TEXCOORD2;
    float4 Light2Dir : TEXCOORD3;
    float4 Att1UV : TEXCOORD4;
    float4 Att2UV : TEXCOORD5;
    float4 ShadowUV0 : TEXCOORD6;
	float4 ShadowUV1 : TEXCOORD7;
};

// Code:

VS_OUTPUT main(VS_INPUT IN) {
    VS_OUTPUT OUT;

#define	expand(v)		(((v) - 0.5) / 0.5)
#define	compress(v)		(((v) * 0.5) + 0.5)

    float3 lit1;
    float3 lit3;
    float4 m28;
	float3 camera;
	
    m28 = mul(ModelViewProj, IN.Position.xyzw);
    lit3.xyz = LightPosition[2].xyz - IN.Position.xyz;
    lit1.xyz = LightPosition[1].xyz - IN.Position.xyz;
	OUT.Position = m28;
    OUT.BaseUV.xy = IN.BaseUV.xy;
    OUT.Light0Dir.xyz = normalize(mul(TanSpaceProj, LightDirection[0].xyz));
    OUT.Light1Dir.xyz = normalize(mul(TanSpaceProj, lit1.xyz));
    OUT.Light2Dir.xyz = normalize(mul(TanSpaceProj, lit3.xyz));
	camera.xyz = normalize(mul(TanSpaceProj, normalize(EyePosition.xyz - IN.Position.xyz)));
	OUT.Light0Dir.w = camera.x;
	OUT.Light1Dir.w = camera.y;
	OUT.Light2Dir.w = camera.z;
    OUT.Att1UV.w = 0.5;
    OUT.Att1UV.xyz = compress(lit1.xyz / LightPosition[1].w);
    OUT.Att2UV.w = 0.5;
    OUT.Att2UV.xyz = compress(lit3.xyz / LightPosition[2].w);
    OUT.ShadowUV0 = mul(m28, TESR_ShadowCameraToLightTransform[0]);
	OUT.ShadowUV1 = mul(m28, TESR_ShadowCameraToLightTransform[1]);
    return OUT;
};

// approximately 55 instruction slots used
